	function [A] = bp_sb_atten_mf(Z,NIN,NZ,q,Z_vec,Amax)
	%  
	% Calculates the stopband attenuation A(Z_vec) in the 
	% Z-frequencies Z_vec given an attenuation pole vector 
	% Z for the BP case with maximally flat passband.
	% Also the number of attenuation poles at infinity NIN 
	% and the number at the origin NZ is required. 
	% q is the passband quotient wb/wb and the passband 
	% attenuation Amax.
	
	% Author: 			Per Loewenborg
    % Modified by:		LW
	% Copyright:		by authors - not released for commercial use
	% Version: 			1	
	% Known bugs:		None
	% Report bugs to:	larsw@isy.liu.se
	
	ep_sqred = (10^(0.1*Amax)) - 1;
	m = NZ+NIN+2*length(Z);
	A_sq = ( (q^(2*NZ))*prod(Z.^4) )^(1/m);
	A = (Z_vec.^2+A_sq).^m;
	A = ep_sqred*A;
	B = (Z_vec.^2-q^2).^NZ;
	B = B.*( (Z_vec.^2-1).^NIN );
	for k = 1:length(Z)
		B = B.*( (Z_vec.^2-Z(k)^2).^2 );   
	end
	A = 10*log10(1+A./B);
